this.name        = "ups_parcel"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Parcel missions of UPS Courier"; 
this.version     = "1.4.0"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.71") > 0)
    {
        // Oolite version is older than 1.71.
        log("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Parcel missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
    }
  //  this.timer= new Timer(this, this.ups_timed_missionOffers, 1, 1); this.timer.stop()
    if(worldScripts.TigersTurf) this.pirates = "tigers"; else this.pirates = "ups_pirate";
    this.mark = false
    this.firstLaunch = true
}

this.reset = function()
{
    this.firstLaunch = true
}

this.shipDockedWithStation = function()
{
    this.ups_missionOffers()
}

/*
this.ups_timed_missionOffers = function()
{
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return
    this.timer.stop()
    if (player.docked) this.ups_missionOffers()
}
*/

this.longRangeChart = function()
{
    if(guiScreen == "GUI_SCREEN_LONG_RANGE_CHART")
    {
        if(this.mark) {mission.unmarkSystem(missionVariables.ups_pplanet); this.mark = false}
        else {mission.markSystem(missionVariables.ups_pplanet); this.mark = true}
    }
    else
    {
        this.missionChartTimer.stop()
        mission.unmarkSystem(missionVariables.ups_pplanet)
        this.mark = true // Keep this selected system, don't roll dices again.
        missionVariables.offering = null
        mission.choice = null
        if(player.docked) this.ups_missionOffers()
    }
}

this.ups_missionOffers = function()
{
    if (guiScreen == "GUI_SCREEN_MISSION") return; // there will be a "missionScreenEnded" in future to react uppon.
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return;
   // if (missionVariables.offering || (mission.choice && mission.choice != "")) {this.timer.start(); return}
    // there might not be a "missionScreenEnded" in future to react uppon, so set up an timer. In 1.71 there will be a missionChoiceWasReset event.
    if (player.dockedStation.isMainStation)
    {
        if (missionVariables.ups_parcel == "YES")
        {
            if (system.government == 4 && missionVariables.ups_dcount > 2 && player.bounty < 3 && !mission.choice)
            {
                missionVariables.ups_parcel_appearance = expandDescription("[ups_numbers]") + " " + expandDescription("[ups_colors]") + " " + expandDescription("[%I]")
                if (missionVariables.ups_pcount == 0)
                {mission.runMissionScreen("ups_parcel_1st_offer", "UPS.png", "ups_parcel_accepted_yesno")}
                else {mission.runMissionScreen("ups_parcel_offer", "UPS.png", "ups_parcel_accepted_yesno")}
                missionVariables.offering ="UPS_PARCELS"
            }
        }
        if(missionVariables.ups_parcel == "SMALL_DELIVERY")
        {
            if(system.government == 4)
            {
                if(missionVariables.ups_pplanet == system.ID)
                {
                    mission.runMissionScreen("ups_back_at_home", "UPS.png")
                    missionVariables.ups_parcel = "ACCEPTED"
                }
                else
                {
                    missionVariables.ups_parcel = "NOT_NOW"
                    player.credits += 150
                    mission.setInstructionsKey()
                    if (missionVariables.ups_pcount == 0) {mission.runMissionScreen("ups_parcel_1st_unloading", "UPS.png")}
                    else
                    {
                        if(missionVariables.ups_ambush == "YES")
                        {
                            mission.runMissionScreen("ups_parcel_ambush", "UPS.png")
                            player.credits += 500
                        }
                        else
                        {
                            mission.runMissionScreen("ups_parcel_unloading")
                        }
                    }
                    missionVariables.ups_pcount++
                    player.call("increaseContractReputation")
                    missionVariables.ups_parcel_appearance = null 
                    missionVariables.ups_ambush = null 
                    missionVariables.ups_pplanetname = null
                }
            }
        }
        if (missionVariables.ups_parcel == "LOGGING")
        {
            if(system.government == 4 && player.credits > 15000 && missionVariables.ups_pplanet != system.ID && missionVariables.ups_ptimerstart < (clock.days - 8) && !mission.choice)
            {
                if(!this.mark) //has not seen this offer before, aka not used the long range chart option.
                {
                    missionVariables.ups_museumGoods = expandDescription("[ups_museumGoods]")
                    if(!missionVariables.ups_trumbles && missionVariables.trumbles == "TRUMBLE_BOUGHT" && Math.random() < 0.25)
                    {
                        if(player.hasEquipment("EQ_TRUMBLE")){player.removeEquipment("EQ_TRUMBLE")}
                        missionVariables.ups_museumGoods = expandDescription("[ups_trumbles]")
                        missionVariables.ups_trumbles = "ESCAPED"
                    }
                }
                mission.runMissionScreen("ups_parcel_offer2", "UPS.png", "ups_parcel_accepted_yesnolook")
                missionVariables.offering = "UPS_PARCELS2"
            }
        }
        if (missionVariables.ups_parcel == "SPECIAL_DELIVERY")
        {
            if(system.government == 4 && missionVariables.ups_pplanet == system.ID)
            {
                if(missionVariables.ups_trumbles == "ESCAPED")
                {
                    mission.runMissionScreen("ups_parcel_trumbles", "trumblebox.png")
                    player.credits -= 1000
                    missionVariables.ups_trumbles = "YES"
                }
                else
                {
                    mission.runMissionScreen("ups_parcel_unloading2", "UPS.png")
                }
                player.credits += 15000
                missionVariables.ups_pcount++
                mission.setInstructionsKey()
                missionVariables.ups_parcel = "NOT_NOW"
                missionVariables.ups_pplanetname = null
                missionVariables.ups_museumGoods = null
                missionVariables.ups_escorts = null 
                mission.unmarkSystem(missionVariables.ups_pplanet)
                missionVariables.ups_ptimerstart = null 
                player.call("increaseContractReputation")
            }
        }
        if (missionVariables.ups_parcel == "ASTRO_OFFER" && system.government == 3)
        {
            if(system.countShipsWithRole("astrofactory") > 0)
            {
                mission.runMissionScreen("ups_parcel_astroAttack", "UPS.png", "ups_astro_parcel_accepted_yesno")
                this.addAstroPirates(20)
                missionVariables.offering = "UPS_ASTRO_PARCELS"
            }
            else missionVariables.ups_parcel = "NO"
        }
        if (missionVariables.ups_parcel == "ASTRO_DELIVERY" && missionVariables.ups_pplanet == system.ID)
        {
                mission.runMissionScreen("ups_astro_parcel_unloading")
                player.credits += 250
                missionVariables.ups_pcount++
                mission.setInstructionsKey() 
                missionVariables.ups_parcel = "NOT_NOW"
                mission.unmarkSystem(missionVariables.ups_pplanet)
                missionVariables.ups_pplanetname = null
                missionVariables.ups_parcel_appearance = null
        }
        if (missionVariables.ups_parcel == "MIDAIR_DELIVERY" && missionVariables.ups_pplanet == system.ID)
        {
                mission.runMissionScreen("ups_parcel_unloading")
                player.credits += 150
                missionVariables.ups_pcount++
                mission.setInstructionsKey() 
                missionVariables.ups_parcel = "NOT_NOW"
                 mission.unmarkSystem(missionVariables.ups_pplanet)
                missionVariables.ups_pplanetname = null
        }
    }
    if (player.dockedStation.shipDescription == "Imperial AstroFactory" && missionVariables.ups_parcel == "ASTRO_ACCEPTED")
    {
            mission.runMissionScreen("ups_astro_parcel_loading")
            missionVariables.ups_parcel = "ASTRO_DELIVERY"
            let astroPirates = system.shipsWithRole("pirate", player, 40000) // all pirates in a radius of 40000 m around the player
            for (let i=0; i<astroPirates.length;i++)
                if(astroPirates[i]) //could have already been destroyed or not present
                {
                    astroPirates[i].switchAI("upsAmbushPirateAI.plist")
                }
    }
}

this.ups_choiceEvaluation = function()
{
    if (missionVariables.offering == "UPS_PARCELS")
    {
        if(mission.choice == "YESParcel")
        {
            mission.setInstructionsKey("ups_parcel_small") 
            missionVariables.ups_parcel = "ACCEPTED" 
            missionVariables.offering = null
            missionVariables.ups_pplanet = system.ID 
            missionVariables.ups_pplanetname = expandDescription("[%H]")
            mission.choice = null
            if (Math.random() < 0.2 && missionVariables.ups_pcount > 1) {missionVariables.ups_ambush = "POSSIBLE"}
        }
        else
        {
            if (mission.choice == "NOParcel")
            {
                missionVariables.ups_parcel = "NOT_NOW" 
                missionVariables.offering = null
                missionVariables.ups_parcel_appearance = null
                mission.choice = null
                if (Math.random() < 0.3){player.call("decreaseContractReputation")}
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
    if (missionVariables.offering == "UPS_PARCELS2")
    {
        this.mark = false
        if(mission.choice == "YESParcel")
        {
            mission.setInstructionsKey("ups_parcel_small2") 
            missionVariables.ups_parcel = "SPECIAL_DELIVERY" 
            missionVariables.offering = null
            mission.markSystem(missionVariables.ups_pplanet) 
            player.credits -= 10000
            missionVariables.ups_escorts = 8
            mission.choice = null
        }
        else
        {
            if(mission.choice == "LOOKParcel")
            {
                player.call("setGuiToLongRangeChartScreen")
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NOParcel")
                {
                    missionVariables.ups_parcel = "NOT_NOW" 
                    missionVariables.offering = null
                    mission.choice = null
                } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "UPS_ASTRO_PARCELS")
    {
        if(mission.choice == "YESParcel")
        {
            mission.setInstructionsKey("ups_astro_parcel_small") 
            missionVariables.ups_parcel = "ASTRO_ACCEPTED" 
            missionVariables.offering = null
            missionVariables.ups_parcel_appearance = "imperial astrofactory"
            missionVariables.ups_pplanet = system.ID 
            missionVariables.ups_pplanetname = expandDescription("[%H]")
            mission.markSystem(missionVariables.ups_pplanet)
            mission.choice = null
        }
        else
        {
            if (mission.choice == "NOParcel")
            {
                missionVariables.ups_parcel = "NOT_NOW" 
                missionVariables.offering = null
                mission.choice = null
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
}

this.missionScreenEnded = function()
{
    if(!player.docked) return;
    this.ups_choiceEvaluation()
    this.ups_missionOffers()
}

this.missionChoiceWasReset = function() // available in 1.71
{
    if(!player.docked) return;
    this.ups_missionOffers()
}

this.addAstroPirates = function(amount)
{
    system.legacy_addShipsAt("pirate", amount, "wpu", 0, 0, 0.3)
    let astroFactorys = system.shipsWithRole("astrofactory")
    let astroFactory = astroFactorys[0]
    let astroPirates = system.shipsWithRole("pirate", astroFactory)
    for (let i=0; i<amount;i++)
        if(astroPirates[i])
        {
            astroPirates[i].switchAI("upsAstroPirateAI.plist")
            if(astroPirates[i].bounty == 0) astroPirates[i].bounty = Math.random()*100
        }
}

this.shipLaunchedFromStation = function()
{
    if(this.firstLaunch && missionVariables.ups_parcel == "ASTRO_ACCEPTED" && system.countShipsWithRole("astrofactory") > 0)
    {
        this.addAstroPirates(20)
    }
    this.firstLaunch = false
}

this.shipExitedWitchspace = function()
{
    if(missionVariables.ups_parcel == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_parcel = "NO"}
    if(missionVariables.ups_parcel == "NO")
    {
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.2 && system.government == 4)
        {missionVariables.ups_parcel = "YES"}
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.05 && system.government == 4 && player.credits > 15000 && !system.goneNova && missionVariables.ups_pcount > 5)
        {
            missionVariables.ups_parcel = "LOGGING"
            missionVariables.ups_pplanet = system.ID
            missionVariables.ups_pplanetname = expandDescription("[%H]")
            missionVariables.ups_ptimerstart = clock.days
        }
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.1)
        {
            if(system.government > 3 && system.economy > 3 && missionVariables.ups_tcount > 1)
            system.legacy_addSystemShips("derelict2_ptt", 1, Math.random()*0.8+0.1)
        }
        if(missionVariables.ups_parcel == "NO" && missionVariables.ups_trumbles == "YES")
        {
            player.awardEquipment("EQ_TRUMBLE")
            missionVariables.ups_trumbles = "INFECTED"
        }
        if(missionVariables.ups_parcel == "NO" && Math.random() < 0.2 && worldScripts.dictatorship_population !== undefined && system.government == 3 && system.economy < 3 && missionVariables.ups_pcount > 10)
        {
            missionVariables.ups_parcel = "ASTRO_OFFER"
        }
    }
    else
    {
        if(missionVariables.ups_parcel == "ACCEPTED"){missionVariables.ups_parcel = "SMALL_DELIVERY"}
        if(missionVariables.ups_parcel == "SMALL_DELIVERY" && system.ID > -1)
        {
            system.legacy_addSystemShips("ups_pirate", 3, 0.33)
            if(Math.random() < 0.1 && missionVariables.ups_ambush == "POSSIBLE")
            {missionVariables.ups_ambush = "YES";player.consoleMessage("Ambush, you are spotted.", 6)}
        }
        if(missionVariables.ups_ambush == "YES" && Math.random() < 0.5 && system.ID > -1)
        {
            system.legacy_addShips(this.pirates, 1)
            system.legacy_addSystemShips(this.pirates, 2, 0.2)
            if(player.score > 1000 && (Math.random()*100 + missionVariables.ups_pcount - 2*system.government) > 70)
            {
                system.legacy_addShips("ups_pirate", 3)
                system.legacy_addSystemShips(this.pirates, 3, Math.random())
                system.legacy_addSystemShips("ups_pirate_leader", 1, Math.random())
            }
            if(player.score > 2500 && (Math.random()*100 + missionVariables.ups_pcount - 2*system.government) > 70)
            {
                system.legacy_addShips(this.pirates, 3)
                system.legacy_addSystemShips(this.pirates, 3, Math.random())
                system.legacy_addSystemShips("ups_pirate_leader", 1, Math.random())
                if(worldScripts.hardpirates1 !== undefined) 
                {
                    system.legacy_addShips("hardpirates", 1)
                    let hardpirates = system.shipsWithPrimaryRole("hardpirates", player);
                    if(hardpirates[0]) hardpirates[0].switchAI("upsAmbushPirateAI.plist")
                }
            }
            let ambushpirates = system.shipsWithPrimaryRole("pirate", player);
            for (let i=0; i<ambushpirates.length;i++)
                if(ambushpirates[i]) //could have already been destroyed or not present
                {
                    if(ambushpirates[i].AI == "pirateAI.plist") ambushpirates[i].switchAI("upsAmbushPirateAI.plist")
                }
        }
        if(missionVariables.ups_parcel == "SPECIAL_DELIVERY" && system.ID > -1)
        {
            system.legacy_addShips("escort_ups", missionVariables.ups_escorts)
            if(Math.random() < 0.5)
            {
                system.legacy_addSystemShips("ups_pirate", 4, 0.05)
                system.legacy_addSystemShips("ups_pirate", 3, 0.075)
                system.legacy_addSystemShips("ups_pirate", 3, 0.10)
                system.legacy_addSystemShips("ups_pirate", 2, 0.125)
                system.legacy_addSystemShips("ups_pirate", 1, 0.15)
                let parcelpirates1 = system.shipsWithPrimaryRole("ups_pirate", player);
                for (let i=0; i<13;i++)
                    if(parcelpirates1[i]) //could have already been destroyed
                    {
                        parcelpirates1[i].switchAI("upsParcelPirateAI.plist")
                    }
            }
            if(Math.random() < 0.25) 
            {
                system.legacy_addSystemShips(this.pirates, 5, 0)
		let parcelpirates2 = system.shipsWithPrimaryRole(this.pirates, player, 30000);
		for (let i=0; i<5;i++)
                    if(parcelpirates2[i]) //could have already been destroyed
                    {
                        parcelpirates2[i].switchAI("upsParcelPirateAI.plist")
                    }
            }
            system.legacy_addSystemShips("pirate", 5, Math.random())
            let parcelpirates3 = system.shipsWithPrimaryRole("pirate", player);
            for (let i=0; i<parcelpirates3.length; i++)
                if(parcelpirates3[i]) //could have already been destroyed
                {
                    parcelpirates3[i].switchAI("upsParcelPirateAI.plist")
                }
        }
    }
    if(missionVariables.ups_parcel == "ASTRO_ACCEPTED")
    {
        mission.setInstructionsKey() 
        missionVariables.ups_parcel = "NOT_NOW"
        mission.unmarkSystem(missionVariables.ups_pplanet)
        missionVariables.ups_pplanetname = null
        missionVariables.ups_parcel_appearance = null
    }
}

this.playerEnteredNewGalaxy = function()
{
    // reset missions on galactic jump
    if(missionVariables.ups_parcel == "LOGGING" || missionVariables.ups_parcel == "SPECIAL_DELIVERY" || missionVariables.ups_parcel == "ASTRO_ACCEPTED" || missionVariables.ups_parcel == "MIDAIR_DELIVERY")
    {
            missionVariables.ups_pplanetname = null
            mission.setInstructionsKey()
            mission.unmarkSystem(missionVariables.ups_pplanet)
            missionVariables.ups_pplanet = null
            missionVariables.ups_parcel = "NOT_NOW" 
            missionVariables.ups_ptimerstart = null
    }
    if(!player.hasEquipment("EQ_TRUMBLE")){missionVariables.ups_trumbles = null}
}
